<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use Symfony\Component\HttpFoundation\Response;

class DemoMode
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if (env('DEMO_MODE', false)) {
            $adminDisabledRoutes = [
                'admin.business.delete-all',
                'admin.business.update',
                'admin.business.destroy',
                'admin.business.status',
                'admin.business-categories.delete-all',
                'admin.business-categories.update',
                'admin.business-categories.destroy',
                'admin.banners.store',
                'admin.banners.delete-all',
                'admin.banners.status',
                'admin.banners.update',
                'admin.banners.destroy',
                'admin.plans.store',
                'admin.plans.delete-all',
                'admin.plans.status',
                'admin.plans.update',
                'admin.plans.destroy',
                'admin.users.store',
                'admin.users.delete-all',
                'admin.users.status',
                'admin.users.update',
                'admin.users.destroy',
                'admin.affiliate-withdrawals.delete-all',
                'admin.affiliate-withdrawals.status',
                'admin.affiliates.store',
                'admin.affiliates.delete-all',
                'admin.affiliates.filter',
                'admin.affiliates.status',
                'admin.affiliates.update',
                'admin.affiliates.destroy',
                'admin.subscription-reports.paid',
                'admin.subscription-reports.reject',
                'admin.roles.update',
                'admin.roles.destroy',
                'admin.permissions.index',
                'admin.addons.store',
                'admin.addons.show',
                'admin.manage-settings.store',
                'admin.website-settings.update',
                'admin.features.delete-all',
                'admin.features.status',
                'admin.features.update',
                'admin.features.destroy',
                'admin.blogs.delete-all',
                'admin.blogs.status',
                'admin.blogs.update',
                'admin.blogs.destroy',
                'admin.comments.delete-all',
                'admin.comments.update',
                'admin.comments.destroy',
                'admin.testimonials.delete-all',
                'admin.testimonials.status',
                'admin.testimonials.update',
                'admin.testimonials.destroy',
                'admin.interfaces.delete-all',
                'admin.interfaces.status',
                'admin.interfaces.update',
                'admin.interfaces.destroy',
                'admin.term-conditions.store',
                'admin.privacy-policy.store',
                'admin.messages.delete-all',
                'admin.messages.update',
                'admin.messages.destroy',
                'admin.currencies.delete-all',
                'admin.currencies.update',
                'admin.currencies.destroy',
                'admin.gateways.update',
                'admin.system-settings.store',
                'admin.settings.update',
                'admin.profiles.update',
            ];

            $businessDisabledRoutes = [
                'business.sales.store.customer',
                'business.purchases.store.supplier',
                'business.products.store',
                'business.products.delete-all',
                'business.products.update',
                'business.products.destroy',
                'business.barcodes.store',
                'business.categories.store',
                'business.categories.delete-all',
                'business.categories.update',
                'business.categories.destroy',
                'business.units.store',
                'business.units.delete-all',
                'business.units.update',
                'business.units.destroy',
                'business.brands.store',
                'business.brands.delete-all',
                'business.brands.update',
                'business.brands.destroy',
                'business.medicine-types.store',
                'business.medicine-types.delete-all',
                'business.medicine-types.update',
                'business.medicine-types.destroy',
                'business.manufacturers.store',
                'business.manufacturers.delete-all',
                'business.manufacturers.update',
                'business.manufacturers.destroy',
                'business.product-models.store',
                'business.product-models.delete-all',
                'business.product-models.update',
                'business.product-models.destroy',
                'business.box-sizes.store',
                'business.box-sizes.delete-all',
                'business.box-sizes.update',
                'business.box-sizes.destroy',
                'business.parties.store',
                'business.parties.delete-all',
                'business.parties.update',
                'business.parties.destroy',
                'business.incomes.delete-all',
                'business.incomes.update',
                'business.incomes.destroy',
                'business.expenses.delete-all',
                'business.expenses.update',
                'business.expenses.destroy',
                'business.taxes.store',
                'business.taxes.deleteAll',
                'business.taxes.status',
                'business.taxes.update',
                'business.taxes.destroy',
                'business.settings.update',
                'business.roles.store',
                'business.roles.update',
                'business.roles.destroy',
                'business.roles.delete-all',
                'business.payment-types.store',
                'business.payment-types.delete-all',
                'business.payment-types.status',
                'business.payment-types.update',
                'business.payment-types.destroy',
                'business.vats.store',
                'business.vats.deleteAll',
                'business.vats.update',
                'business.vats.destroy',
                'business.bulk-uploads.store',
                'business.profiles.update',
                'business.manage-settings.store',
                'business.manage-settings.update',
                'business.manage-settings.destroy',
                'business.product.settings.update',
                'business.roles.update',
                'business.roles.destroy',
                'brands.store',
                'brands.update',
                'brands.destroy',
                'box-sizes.store',
                'box-sizes.update',
                'box-sizes.destroy',
                'bulk-uploads.store',
                'business.store',
                'business.update',
                'categories.store',
                'categories.update',
                'categories.destroy',
                'api.change-password',
                'dues.store',
                'expense-categories.store',
                'expense-categories.update',
                'expense-categories.destroy',
                'expenses.update',
                'expenses.destroy',
                'income-categories.store',
                'income-categories.update',
                'income-categories.destroy',
                'incomes.update',
                'incomes.destroy',
                'lang.store',
                'manufacturer.store',
                'manufacturer.update',
                'manufacturer.destroy',
                'medicine-types.store',
                'medicine-types.update',
                'medicine-types.destroy',
                'parties.store',
                'parties.update',
                'parties.destroy',
                'password-reset',
                'payment-types.store',
                'payment-types.update',
                'payment-types.destroy',
                'products.store',
                'products.update',
                'products.destroy',
                'profile.store',
                'send-reset-code',
                'stock-update',
                'taxes.store',
                'taxes.update',
                'taxes.destroy',
                'units.store',
                'units.update',
                'units.destroy',
                'users.store',
                'users.update',
                'users.destroy',
                'product-settings.store',
                'product-models.store',
                'product-models.update',
                'product-models.destroy',
                'vats.store',
                'vats.update',
                'vats.destroy',
                'warehouses.store',
                'warehouses.update',
                'warehouses.destroy',
                'multibranch.branches.store',
                'multibranch.branches.update',
                'multibranch.branches.status',
                'multibranch.branches.destroy',
                'multibranch.branches.delete-all'
            ];

            if (in_array(Route::currentRouteName(), $adminDisabledRoutes)) {
                return response()->json(['message' => 'This action is disabled in demo mode.'], 499);
            } elseif (auth()->check() && auth()->user()->email == 'shopowner@acnoo.com' && in_array(Route::currentRouteName(), $businessDisabledRoutes)) {
                return response()->json(['message' => 'This action is disabled in demo account. Please sign up your own account for full access.'], 499);
            }
        }

        return $next($request);
    }
}
